 
function changeLanguage(lang) {
     
 
    // Stocker la langue choisie dans le localStorage
    localStorage.setItem('preferredLanguage', lang);
    setValidationMessages(lang);
    // Charger le fichier JSON correspondant à la langue
    $.ajax({
        url: `./languages/${lang}.json`, // URL du fichier JSON de langue
        method: 'GET',
        dataType: 'json',
        success: function(data) {
            // Traiter les données de traduction ici
            document.querySelectorAll('[data-translate]').forEach(element => {
                const key = element.getAttribute('data-translate');
               
                if (data[key]) {
                    element.innerHTML = data[key];
                }
            });
    
            // Pour les placeholders des champs de formulaire
            document.querySelectorAll('[data-translate-placeholder]').forEach(element => {
                const key = element.getAttribute('data-translate-placeholder');
                if (data[key]) {
                    element.setAttribute('placeholder', data[key]);
                }
            });
        },
        error: function(error) {
            console.error("Erreur lors du chargement du fichier JSON:", error);
        }
    });
}
const validationMessages = {
    fr: {
        required: "Ce champ est requis.",
        email: "Veuillez entrer une adresse email valide.",
        pattern: "Le format est incorrect.",
        minlength: "Ce champ doit comporter au moins {min} caractères."
    },
    nl: {
        required: "Dit veld is verplicht.",
        email: "Voer een geldig e-mailadres in.",
        pattern: "Het formaat is onjuist.",
        minlength: "Dit veld moet minimaal {min} tekens bevatten."
    },
    en: {
        required: "This field is required.",
        email: "Please enter a valid email address.",
        pattern: "The format is incorrect.",
        minlength: "This field must contain at least {min} characters."
    }
};


function setValidationMessages(lang) {
 
    document.querySelectorAll('input, textarea, select').forEach(element => {
        element.addEventListener('input', () => {
            // Réinitialiser le message de validation à chaque modification
            element.setCustomValidity("");
        });

        element.addEventListener('invalid', () => {
            // Message personnalisé pour chaque type d'erreur
            if (element.validity.valueMissing) {
                element.setCustomValidity(validationMessages[lang].required);
            } else if (element.validity.typeMismatch && element.type === "email") {
                element.setCustomValidity(validationMessages[lang].email);
            } else if (element.validity.patternMismatch) {
                element.setCustomValidity(validationMessages[lang].pattern);
            } else if (element.validity.tooShort) {
                const min = element.getAttribute('minlength');
                element.setCustomValidity(validationMessages[lang].minlength.replace("{min}", min));
            }
        });
    });
}

document.addEventListener('DOMContentLoaded', function () {
  
    // Utiliser la langue sauvegardée ou 'fr' par défaut
    const savedLanguage = localStorage.getItem('preferredLanguage') || 'fr';
    changeLanguage(savedLanguage)
    setValidationMessages(savedLanguage);
});

 