<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmation - Fun Radio</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Montserrat', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #ff087c 0%, #085aff 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: white;
            overflow-x: hidden;
            text-align: center;
            padding: 2rem;
        }

        .success-container {
            max-width: 800px;
            width: 90%;
            padding: 3rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            animation: fadeIn 1s ease-out;
        }

        @keyframes fadeIn {
            0% { opacity: 0; transform: translateY(20px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        .logo {
            max-width: 220px;
            margin-bottom: 2rem;
            filter: drop-shadow(0 0 10px rgba(255, 255, 255, 0.5));
        }

        h1 {
            font-size: 2.8rem;
            margin-bottom: 1.5rem;
            color: #FFD700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
            font-weight: 800;
        }

        p {
            font-size: 1.3rem;
            margin-bottom: 2rem;
            line-height: 1.6;
        }

        .success-icon {
            font-size: 5rem;
            color: #FFD700;
            margin-bottom: 2rem;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        .back-button {
            background: linear-gradient(to right, #FFD700, #B8860B);
            color: #fff;
            border: none;
            padding: 1rem 2rem;
            font-size: 1.2rem;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: bold;
            text-decoration: none;
            display: inline-block;
            margin-top: 2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .back-button:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }

        .confetti {
            position: fixed;
            width: 10px;
            height: 10px;
            background-color: #ffd700;
            position: absolute;
            top: 0;
            z-index: -1;
            animation: confetti-fall 5s linear forwards;
        }

        @keyframes confetti-fall {
            0% { transform: translateY(0) rotate(0deg); opacity: 1; }
            100% { transform: translateY(100vh) rotate(720deg); opacity: 0; }
        }

        @media (max-width: 768px) {
            h1 {
                font-size: 2rem;
            }

            p {
                font-size: 1.1rem;
            }

            .success-icon {
                font-size: 4rem;
            }
        }
    </style>
</head>
<body>
    <div class="success-container">
        <img src="logo.png" alt="Fun Radio " class="logo">
        <!-- <i class="fas fa-check-circle success-icon"></i> -->
        <h1>Félicitations !</h1>
        <p>Votre demande a été validée avec succès. Votre gain sera versé sur votre compte dans les prochaines heures. Merci d'avoir participé au jeu concours Fun Radio !</p>
        <!-- <p>Un email de confirmation a été envoyé à l'adresse que vous avez fournie.</p> -->
        <!-- <a href="index.php" class="back-button">RETOUR AU JEU CONCOURS</a> -->
    </div>

    <script>
        // Créer des confettis pour célébrer
        function createConfetti() {
            const colors = ['#ff087c', '#085aff', '#FFD700', '#ffffff'];
            for (let i = 0; i < 100; i++) {
                const confetti = document.createElement('div');
                confetti.className = 'confetti';
                confetti.style.left = Math.random() * 100 + 'vw';
                confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.width = Math.random() * 10 + 5 + 'px';
                confetti.style.height = Math.random() * 10 + 5 + 'px';
                confetti.style.animationDuration = Math.random() * 3 + 2 + 's';
                document.body.appendChild(confetti);
                
                // Supprimer les confettis après l'animation
                setTimeout(() => {
                    confetti.remove();
                }, 5000);
            }
        }

        // Lancer les confettis au chargement de la page
        window.onload = createConfetti;
    </script>
</body>
</html>